package ch.frankel.blog.spring.authoring.ehcache;

import static junit.framework.Assert.assertEquals;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Parameterized.Parameters;
import org.mockito.BDDMockito;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.parsing.EmptyReaderEventListener;
import org.springframework.beans.factory.parsing.FailFastProblemReporter;
import org.springframework.beans.factory.parsing.NullSourceExtractor;
import org.springframework.beans.factory.parsing.ReaderEventListener;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.SimpleBeanDefinitionRegistry;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.core.io.DescriptiveResource;
import org.springframework.core.io.Resource;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

@RunWith(Parameterized.class)
public class EhCacheBeanDefinitionParserTest {

	private static EhCacheBeanDefinitionParser parser;

	private static ParserContext context;

	private static Element element;

	private static NamedNodeMap nnm;

	private String key;
	
	private String value;
	
	public EhCacheBeanDefinitionParserTest(String key, String value) {
		
		this.key = key;
		this.value = value;
	}
	
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {

		parser = new EhCacheBeanDefinitionParser();

		NullSourceExtractor sourceExtractor = new NullSourceExtractor();

		XmlBeanDefinitionReader xbdr = new XmlBeanDefinitionReader(
				new SimpleBeanDefinitionRegistry());

		ReaderEventListener listener = new EmptyReaderEventListener();

		FailFastProblemReporter ffpr = new FailFastProblemReporter();

		Resource resource = new DescriptiveResource("test");

		XmlReaderContext readerContext = new XmlReaderContext(resource, ffpr,
				listener, sourceExtractor, xbdr, null);

		context = new ParserContext(readerContext,
				new BeanDefinitionParserDelegate(readerContext));

		element = BDDMockito.mock(Element.class);

		nnm = BDDMockito.mock(NamedNodeMap.class);

		BDDMockito.given(element.getAttributes()).willReturn(nnm);

		BDDMockito.given(nnm.getLength()).willReturn(5);

		NodeList nodes = BDDMockito.mock(NodeList.class);

		BDDMockito.given(element.getLocalName()).willReturn("cache");
		BDDMockito.given(element.getElementsByTagNameNS(
			"http://blog.frankel.ch/spring/ehcache", "manager")).willReturn(nodes);
	}

	@Before
	public void setUp() {
		
		BDDMockito.given(element.getAttribute(key)).willReturn(value);
	}
	
	@Test
	public void testParse() {

		BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition();
		
		parser.doParse(element, context, builder);

		AbstractBeanDefinition definition = builder.getBeanDefinition();
		
		MutablePropertyValues mpv = definition.getPropertyValues();
		
		assertEquals(value, mpv.getPropertyValue(key).getValue());
	}
	
	@Parameters
	public static Collection<Object[]> getParameters() {
		
		Object[][] parameters = new Object [3][2];
		
		parameters[0] = new String[] {"eternal", "true"};
		parameters[1] = new String[] {"timeToLive", "3"};
		parameters[2] = new String[] {"timeToIdle", "32541432"};
		
		return Arrays.asList(parameters);
	}
}
